
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 28 12:09:38 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_SST_TST_ATP_Asym.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ***********************************/
#include "SST_TST.h"
#if TST_USE_CRYS_SST_ASYM_MODULE
/************************ Defines ******************************/
/************************ Enums ********************************/
/************************ Typedefs *****************************/
/************************ Global Data **************************/
DxUint8_t            TST_N_RSAKey[TST_RSA_MAX_KEYSIZE_BYTES];
DxUint8_t            TST_ASYMInputData[TST_RSA_MAX_KEYSIZE_BYTES] = {0};
DxUint8_t            TST_OutputData[TST_RSA_MAX_KEYSIZE_BYTES]    = {0};
DxUint8_t            TST_ReturnedOutputData[TST_RSA_MAX_KEYSIZE_BYTES] = {0};

/************* Private function prototype **********************/
/************************ Public Functions *********************/
/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_SST_TST_ATP_RSA
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 *    Test the connection between CRYS and the SSTfunctionality while using SST RSA generated keys
 *    in the CRYS_SST module
 *  
 * Algorithm:       
 *    1.    Create a new session by calling: SST_SessionCreate.
 *    2.    Open a transaction by calling: SST_TransactionStart.
 *    3.    Create a new  password authenticator.
 *    4.    Close the transaction.
 *    5.    Open the  password authentication.
      6.    Open a transaction for operations.
 *    7.    Generate RSA key Pair inside the SST by calling: CRYS_SST_RSA_KG_GenerateKeyPair.
 *    8.    Generate RSA CRT key Pair inside the SST by calling: CRYS_SST_RSA_KG_GenerateKeyPairCRT.
 *    9.    Read the RSA Public Key from the SST by calling: SST_RSAPublicKeyRead.
 *    10.   Read the RSA Public CRT Key from the SST by calling: SST_CRTRSAPublicKeyRead.
 *    11.   Build the RSA public key for CRYS usage by calling: CRYS_RSA_Build_PubKey
 *    12.   Build the RSA CRT public key for CRYS usage by calling: CRYS_RSA_Build_PubKey
 *    13.   Sign the data using the SST RSA key by calling: CRYS_SST_RSA_PKCS1v15_Sign.
 *    14.   Sign the data using the SST CRT RSA key by calling: CRYS_SST_RSA_PSS_Sign.
 *    15.   Verify the data signed by the RSA key by calling: CRYS_RSA_PKCS1v15_Verify
 *    16.   Verify the data signed by the RSA CRT key by calling: CRYS_RSA_PSS_Verify
 *    17.   Delete the RSA keys by calling: SST_DataDelete.
 *    18.   Delete the authenticator by calling: SST_AuthenticatorDelete.
 *    19.   Close the transaction by calling: SST_TransactionClose.
 *    20.   Delete the session by calling: SST_SessionDelete.
 *                                
 *******************************************************************************/   
DxError_t CRYS_SST_TST_ATP_RSA ( void )
{
    /********* TST Variables Definitions ************/
    int                         TST_HandleType;
    char                        TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_SST_TST_ATP_RSA";
    SSTSessionId_t              TST_SessionId; 
    SSTTxnId_t                  TST_TransactionId;
    SSTHandle_t            TST_RSA_KeyHandle,TST_RSACRT_KeyHandle,TST_InitialCtrlAuth,TST_PasswordAuthHandle;
    DxUint8_t                   TST_PubExponent[TST_PUB_EXPONENT_SIZE] = {0x01,0x00,0x01};
    DxUint32_t                  TST_RSAKeySizeBits = 0,TST_RSAKeySizeByts,TST_index = 0;
    static CRYS_SST_RSA_keys_and_data_container_t TST_KeyGenData1;
    static CRYS_SST_RSA_pair_keys_container_t     TST_KeyGenData2;
    DxUint8_t                   TST_E_RSAKey[TST_PUB_EXPONENT_SIZE];
    DxUint32_t                  TST_EsizeInBytes_RSAKey = sizeof(TST_E_RSAKey);    
    static DxUint8_t            TST_N_CRTKey[TST_RSA_MAX_KEYSIZE_BYTES];
    static DxUint8_t            TST_E_CRTKey[TST_PUB_EXPONENT_SIZE];
    CRYS_RSAUserPubKey_t        TST_RSA_KeyCTX,TST_RSACRT_KeyCTX;
    static  CRYS_RSAPubUserContext_t    TST_UserPubContext;
    static  CRYS_RSAPrivUserContext_t  TST_UserPrivContext;
    DxUint32_t                  TST_InputDataSize = sizeof(TST_ASYMInputData);
    DxUint8_t                   TST_SignedRSAData[TST_RSA_MAX_KEYSIZE_BYTES] = {0};
    DxUint16_t                  TST_SignedRSADataSize = TST_RSA_MAX_KEYSIZE_BYTES;
    DxUint8_t                   TST_SignedRSACRTData[TST_RSA_MAX_KEYSIZE_BYTES] = {0};
    DxUint16_t                  TST_SignedRSACRTDataSize = TST_RSA_MAX_KEYSIZE_BYTES;
    DxUint16_t                  TST_SaltLen=0;
    CRYS_PKCS1_MGF_t            TST_MGF=CRYS_PKCS1_MGF1;
    DxError_t                   TST_Status = DX_SUCCESS;

    /********* TST Variables initialization *********/

    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ** CRYS_SST_TST_ATP_RSA Tests ********************* \n"));     
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n \n"));

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
    
    //TST_AuthHandle.objDigest = 0;
    for (TST_HandleType = TST_INTERNAL_HANDLE ; TST_HandleType < TST_HANDLES_TYPES ; TST_HandleType++)
    {
            if (TST_HandleType == TST_INTERNAL_HANDLE)
            {   
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using internal handles          \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                TST_RSA_KeyHandle.objId = SST_HANDLE_RANDOM_GENERATE;
                TST_RSACRT_KeyHandle.objId = SST_HANDLE_RANDOM_GENERATE;
              
            }
            else
            {
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using external handles          \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                TST_RSA_KeyHandle.objId = TST_TEST_DEFINED_HENDLE;
                TST_RSACRT_KeyHandle.objId = TST_TEST_DEFINED_HENDLE_1;
               
            }  


            /* Create a session for operations */
            /*---------------------------------*/
            TST_Status = SST_SessionCreate(&TST_SessionId);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                                  "SST_SessionCreate",
                                  "CRYS_SST_TST_ATP_RSA",
                                  TST_MasterTestName);


            /* Open a transaction for operations */
            /*-----------------------------------*/
            TST_Status = SST_TransactionStart(&TST_TransactionId);
            TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                          "SST_TransactionStart",
                          "CRYS_SST_TST_ATP_RSA",
                           TST_MasterTestName);

      /*  Create a new  password authenticator */
      /*--------------------------------------*/
      TST_InitialCtrlAuth.objDigest = 0;
      TST_InitialCtrlAuth.objId = SST_CLOSE_AUTH_HANDLE;
      TST_Status = SST_AuthenticatorPasswordCreate(TST_TransactionId,
                                                   TST_SessionId, 
                                                   TST_ATP_PassAuthObjectTestData[0].TST_MasterPassword,
                                                   TST_ATP_PassAuthObjectTestData[0].TST_MasterPasswordSizeInBytes,
                                                   TST_ATP_PassAuthObjectTestData[0].TST_MasterMaxNumOfTrials,
                                                   TST_InitialCtrlAuth,
                                                   &TST_PasswordAuthHandle,
                                                   TST_Workspace,
                                                   TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorPasswordCreate ",
                                 CRYS_SST_TST_ATP_RSA,
                                 TST_MasterTestName);


      /* Close the transaction */
      /*-----------------------*/
      TST_Status = SST_TransactionEnd(TST_TransactionId, DX_TRUE, TST_Workspace, TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                                 CRYS_SST_TST_ATP_RSA,
                                 TST_MasterTestName);


      /* Open the  password authentication */
      /*-----------------------------------------*/
      TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                          TST_PasswordAuthHandle,
                                          TST_ATP_PassAuthObjectTestData[0].TST_MasterPassword,
                                          TST_ATP_PassAuthObjectTestData[0].TST_MasterPasswordSizeInBytes,
                                          TST_NO_CHALLENGE,
                                          TST_Workspace,
                                          TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen ",
                                 CRYS_SST_TST_ATP_RSA,
                                  TST_MasterTestName);


      /* Open a transaction for operations */
      /*-----------------------------------*/
      TST_Status = SST_TransactionStart(&TST_TransactionId);
      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                                 CRYS_SST_TST_ATP_RSA,
                                 TST_MasterTestName);


            /* Setting test case specific parameters for key sizes */
            for (TST_index =0 ; TST_index < TST_NUM_OF_RSA_KEYS ; TST_index++) /*To run on all key types vectors*/
            {
              switch(TST_index)
              {
                case 0:
                        TST_RSAKeySizeBits = TST_RSA_1024BIT_KEY;
                        TST_RSAKeySizeByts = TST_RSA_1024BIT_KEYSIZE_BYTES;
                        ATP_LOG_TST_PRINT((SST_TST_MSG,"\n*** RSA Key 1024 bit\n"));
                        break;
                case 1:
                        TST_RSAKeySizeBits = TST_RSA_2048BIT_KEY;
                        TST_RSAKeySizeByts = TST_RSA_2048BIT_KEYSIZE_BYTES;
                        /*reinitializing for larger key*/
                        TST_SignedRSADataSize = TST_RSA_MAX_KEYSIZE_BYTES;
                        TST_SignedRSACRTDataSize= TST_RSA_MAX_KEYSIZE_BYTES;
                        ATP_LOG_TST_PRINT((SST_TST_MSG,"\n*** RSA Key 2048 bit\n"));
                        break; 
                default:
                        ATP_LOG_TST_PRINT((SST_TST_MSG,"\n***  wrong RSA Key \n"));

               };

              /* Generate RSA KeyPair inside the SST */
              /*-------------------------------------*/  
              TST_Status = CRYS_SST_RSA_KG_GenerateKeyPair(TST_TransactionId,
                                                          TST_SessionId,
                                                          TST_PasswordAuthHandle,
                                                          TST_RSA_KEYPAIR_TYPE,
                                                          &TST_RSA_KeyHandle,
                                                          TST_PubExponent,
                                                          sizeof(TST_PubExponent),
                                                          TST_RSAKeySizeBits,
                                                          &TST_KeyGenData1);

              TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                                          "CRYS_SST_RSA_KG_GenerateKeyPair",
                                          "CRYS_SST_TST_ATP_RSA",
                                           TST_MasterTestName);


              /* Generate RSA CRT KeyPair inside the SST */
              /*-----------------------------------------*/ 
              TST_Status = CRYS_SST_RSA_KG_GenerateKeyPairCRT(TST_TransactionId,
                                                             TST_SessionId,
                                                             TST_PasswordAuthHandle,
                                                             TST_RSA_CRT_KEYPAIR_TYPE,
                                                             &TST_RSACRT_KeyHandle,
                                                             TST_PubExponent,
                                                             sizeof(TST_PubExponent),
                                                             TST_RSAKeySizeBits,
                                                             &TST_KeyGenData1);

              TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                                            "CRYS_SST_RSA_KG_GenerateKeyPairCRT",
                                            "CRYS_SST_TST_ATP_RSA",
                                             TST_MasterTestName);


              /* Read the RSA public Key from the SST */
              /*--------------------------------------*/
              TST_Status = SST_RSAPublicKeyRead(TST_SessionId,
                                               TST_RSA_KeyHandle,
                                               TST_N_RSAKey,
                                               &TST_RSAKeySizeByts,
                                               TST_E_RSAKey,
                                               &TST_EsizeInBytes_RSAKey,
                                               TST_Workspace,
                                               TST_WorkspaceSizeInBytes);

              TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                                     "SST_RSAPublicKeyRead",
                                     "CRYS_SST_TST_ATP_RSA",
                                    TST_MasterTestName);


              /* Read the RSA CRT public Key from the SST */
              /*------------------------------------------*/
              TST_Status = SST_CRTRSAPublicKeyRead(TST_SessionId,
                                                  TST_RSACRT_KeyHandle,
                                                  TST_N_CRTKey,
                                                  &TST_RSAKeySizeByts,
                                                  TST_E_CRTKey,
                                                  &TST_EsizeInBytes_RSAKey,
                                                  TST_Workspace,
                                                  TST_WorkspaceSizeInBytes);

          	  TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                                         "SST_CRTRSAPublicKeyRead",
                                  			"CRYS_SST_TST_ATP_RSA",
                                   			TST_MasterTestName);


              /* Build the RSA public keys for CRYS usage */
              /*------------------------------------------*/
              TST_Status = CRYS_RSA_Build_PubKey(&TST_RSA_KeyCTX,
                                                TST_E_RSAKey,
                                                (DxUint16_t)TST_EsizeInBytes_RSAKey,
                                                TST_N_RSAKey,
                                                (DxUint16_t)TST_RSAKeySizeByts);

	            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_RSA_Build_PubKey - RSA Key",
	                                       "CRYS_SST_TST_ATP_RSA",
	                                       TST_MasterTestName);



              TST_Status = CRYS_RSA_Build_PubKey(&TST_RSACRT_KeyCTX,
                                                  TST_E_CRTKey,
                                                  (DxUint16_t)TST_EsizeInBytes_RSAKey,
                                                  TST_N_CRTKey,
                                                  (DxUint16_t)TST_RSAKeySizeByts);


	            TST_ATP_CHECK_ERROR_RETURN(TST_Status,
  	                                	   "CRYS_RSA_Build_PubKey - CRT key",
  	                      				       "CRYS_SST_TST_ATP_RSA",
  	                         			       TST_MasterTestName);




              /* Sign the data using SST RSA private key */
              /*-----------------------------------------*/
              TST_Status = CRYS_SST_RSA_PKCS1v15_Sign(TST_RSA_KeyHandle,
                                                     TST_SessionId,
                                                     &TST_UserPrivContext,
                                                     CRYS_RSA_HASH_SHA1_mode,
                                                     TST_ASYMInputData,
                                                     TST_InputDataSize,
                                                     TST_SignedRSAData,
                                                     &TST_SignedRSADataSize,
                                                     &TST_KeyGenData2,
                                                     TST_Workspace,
                                                     TST_WorkspaceSizeInBytes);

              TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                              "CRYS_SST_RSA_PKCS1v15_Sign",
                              "CRYS_SST_TST_ATP_RSA",
                               TST_MasterTestName);


              /* Sign the data using SST RSA CRT private key */
              /*---------------------------------------------*/
              TST_Status = CRYS_SST_RSA_PSS_Sign(TST_RSACRT_KeyHandle,
                                                TST_SessionId,
                                                &TST_UserPrivContext,
                                                CRYS_RSA_HASH_SHA1_mode,
                                                TST_MGF,
                                                TST_SaltLen,
                                                TST_ASYMInputData,
                                                TST_InputDataSize,
                                                TST_SignedRSACRTData,
                                                &TST_SignedRSACRTDataSize,
                                                &TST_KeyGenData2,
                                                TST_Workspace,
                                                TST_WorkspaceSizeInBytes);

              TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                          "CRYS_SST_RSA_PSS_Sign",
                          "CRYS_SST_TST_ATP_RSA",
                           TST_MasterTestName);


              /*Verify the data using RSA extracted public key */
              /*-----------------------------------------------*/
              TST_Status = CRYS_RSA_PKCS1v15_Verify(&TST_UserPubContext,
                                                   &TST_RSA_KeyCTX,
                                                   CRYS_RSA_HASH_SHA1_mode,
                                                   TST_ASYMInputData,
                                                   TST_InputDataSize,
                                                   TST_SignedRSAData);

              TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                          "CRYS_RSA_PKCS1v15_Verify",
                          "CRYS_SST_TST_ATP_RSA",
                           TST_MasterTestName);


              /*Verify the data using RSA CRT extracted public key */
              /*---------------------------------------------------*/
              TST_Status = CRYS_RSA_PSS_Verify(&TST_UserPubContext,
                                              &TST_RSACRT_KeyCTX,
                                              CRYS_RSA_HASH_SHA1_mode,
                                              TST_MGF,
                                              TST_SaltLen,
                                              TST_ASYMInputData,
                                              TST_InputDataSize,
                                              TST_SignedRSACRTData);

              TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                          "CRYS_RSA_PSS_Verify",
                          "CRYS_SST_TST_ATP_RSA",
                           TST_MasterTestName);


              /* Delete the keys */
              /*-----------------*/
              TST_Status = SST_DataDelete(TST_TransactionId,
                                          TST_SessionId,  
                                          TST_RSA_KeyHandle,
                                          TST_Workspace,
                                          TST_WorkspaceSizeInBytes);

              TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                          "SST_DataDelete - RSA key",
                          "CRYS_SST_TST_ATP_RSA",
                           TST_MasterTestName);


              TST_Status = SST_DataDelete(TST_TransactionId,
                                        TST_SessionId,  
                                        TST_RSACRT_KeyHandle,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

              TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                          "SST_DataDelete - RSA CRT key",
                          "CRYS_SST_TST_ATP_RSA",
                           TST_MasterTestName);

            }


            /*Delete the pass Authenticator*/
            TST_Status = SST_AuthenticatorDelete(TST_TransactionId,TST_PasswordAuthHandle);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorDelete",
              "CRYS_SST_TST_ATP_RSA",
              TST_MasterTestName);


            /* Close the transaction */
            /*-----------------------*/
            TST_Status = SST_TransactionEnd(TST_TransactionId,
                             DX_TRUE,/*reflash sensitive*/
                             TST_Workspace,
                             TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                          "SST_TransactionEnd",
                          "CRYS_SST_TST_ATP_RSA",
                           TST_MasterTestName);


            /* Delete the session */
            /*--------------------*/
            TST_Status = SST_SessionDelete(TST_SessionId);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                          "SST_SessionDelete",
                          "CRYS_SST_TST_ATP_RSA",
                           TST_MasterTestName);

    }/*End of TST_HandleType "for loop" */
    return TST_Status;

EXIT_ON_ERROR: 
    return DX_FAILURE;
  
}/* End of CRYS_SST_TST_ATP_RSA */

/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/
/*****************************************************************************
* Function Name:                                                           
*   CRYS_SST_TST_ATP_RSA_OAEP_ENCDEC
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* Description:                                                                 
*    Test the CRYS_SST functions CRYS_SST_RSA_OAEP_Encrypt and CRYS_SST_RSA_OAEP_Decrypt
* 
* Algorithm:       
*    1.    Create a new session by calling: SST_SessionCreate.
*    2.    Open a transaction by calling: SST_TransactionStart.
*    3.    Create a new  password authenticator
*    4.    Close the transaction
*    5.    Open the  password authentication
*    6.    Open a transaction for operations
*    7.    Generate RSA key Pair inside the SST by calling: CRYS_SST_RSA_KG_GenerateKeyPair.
*    8.    Encrypt the input buffer by calling CRYS_SST_RSA_OAEP_Encrypt. 
*    9.    Decrypt the encrypted input buffer by calling CRYS_SST_RSA_OAEP_Decrypt . 
*    10.   Verify decrypted buffer equals the input buffer.
*    11.   Delete key.
*    12.   Delete the pass Authenticator
*    13.   Close the transaction by calling: SST_TransactionClose.
*    14.   Delete the session by calling: SST_SessionDelete.
*                                
*******************************************************************************/     
DxError_t CRYS_SST_TST_ATP_RSA_OAEP_ENCDEC ( void )
{
    /********* TST Variables Definitions ************/
    int                         TST_HandleType;
    char                        TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_SST_TST_ATP_RSA_OAEP_ENCDEC";
    SSTSessionId_t              TST_SessionId; 
    SSTTxnId_t                  TST_TransactionId;
    SSTHandle_t                 TST_RSA_KeyHandle,TST_PasswordAuthHandle,TST_InitialCtrlAuth;
    DxUint8_t                   TST_PubExponent[TST_PUB_EXPONENT_SIZE] = {0x01,0x00,0x01};
    DxUint32_t                  TST_RSAKeySizeBits = 0,TST_RSAKeySizeByts = 0,TST_index = 0;
    static CRYS_SST_RSA_keys_and_data_container_t TST_KeyGenData1;
    static CRYS_SST_RSA_keys_and_prime_data_container_t TST_keysAndPrimeDataCon;
    DxUint16_t                  TST_InputDataSize = TST_RSA_OAEP_DATA_IN_SIZE;
    DxUint8_t                   TST_EncOutput[TST_RSA_MAX_KEYSIZE_BYTES] = {0};    
    DxUint8_t                   TST_DecOutput[TST_RSA_MAX_KEYSIZE_BYTES] = {0};
    DxUint16_t                  TST_DecOutputSize = TST_RSA_MAX_KEYSIZE_BYTES;
    DxError_t                   TST_Status = TESTPASS;
    CRYS_PKCS1_MGF_t            TST_MGF=CRYS_PKCS1_MGF1;
    DxInt_t i;

    for(i = 0; i< TST_RSA_OAEP_DATA_IN_SIZE; i++)
      TST_ASYMInputData[i] =(DxUint8_t) i;


    /********* TST Variables initialization *********/

    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ** CRYS_SST_TST_ATP_RSA_OAEP_ENCDEC Tests ********************* \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n \n"));

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
    
   
    for (TST_HandleType = TST_INTERNAL_HANDLE ; TST_HandleType < TST_HANDLES_TYPES ; TST_HandleType++)
    {
       if (TST_HandleType == TST_INTERNAL_HANDLE)
       {   
          ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
          ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using internal handles          \n"));
          ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
          TST_RSA_KeyHandle.objId = SST_HANDLE_RANDOM_GENERATE;
         
         }
         else
         {
           ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
           ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using external handles          \n"));
           ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
           TST_RSA_KeyHandle.objId = TST_TEST_DEFINED_HENDLE;
           
         }

       /* Create a session for operations */
       /*---------------------------------*/
       TST_Status = SST_SessionCreate(&TST_SessionId);

       TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                 "SST_SessionCreate",
                                 "CRYS_SST_TST_ATP_RSA_OAEP_ENCDEC",
                                  TST_MasterTestName);


        /* Open a transaction for operations */
        /*-----------------------------------*/
        TST_Status = SST_TransactionStart(&TST_TransactionId);
        TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                  "SST_TransactionStart",
                                  "CRYS_SST_TST_ATP_RSA_OAEP_ENCDEC",
                                   TST_MasterTestName);

          /* Create a new  password authenticator */
      /*--------------------------------------*/
      TST_InitialCtrlAuth.objDigest = 0;
      TST_InitialCtrlAuth.objId = SST_CLOSE_AUTH_HANDLE;
      TST_PasswordAuthHandle.objDigest = 0;
      TST_PasswordAuthHandle.objId = SST_HANDLE_RANDOM_GENERATE; 
      TST_Status = SST_AuthenticatorPasswordCreate(TST_TransactionId,
                                                   TST_SessionId, 
                                                   TST_ATP_PassAuthObjectTestData[0].TST_MasterPassword,
                                                   TST_ATP_PassAuthObjectTestData[0].TST_MasterPasswordSizeInBytes,
                                                   TST_ATP_PassAuthObjectTestData[0].TST_MasterMaxNumOfTrials,
                                                   TST_InitialCtrlAuth,
                                                   &TST_PasswordAuthHandle,
                                                   TST_Workspace,
                                                   TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorPasswordCreate ",
                                 CRYS_SST_TST_ATP_RSA_OAEP_ENCDEC,
                                 TST_MasterTestName);


      /* Close the transaction */
      /*-----------------------*/
      TST_Status = SST_TransactionEnd(TST_TransactionId, DX_TRUE, TST_Workspace, TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                                 CRYS_SST_TST_ATP_RSA_OAEP_ENCDEC,
                                 TST_MasterTestName);


      /* Open the  password authentication */
      /*-----------------------------------------*/
      TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                          TST_PasswordAuthHandle,
                                          TST_ATP_PassAuthObjectTestData[0].TST_MasterPassword,
                                          TST_ATP_PassAuthObjectTestData[0].TST_MasterPasswordSizeInBytes,
                                          TST_NO_CHALLENGE,
                                          TST_Workspace,
                                          TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen ",
                                 CRYS_SST_TST_ATP_RSA_OAEP_ENCDEC,
                                  TST_MasterTestName);


      /* Open a transaction for operations */
      /*-----------------------------------*/
      TST_Status = SST_TransactionStart(&TST_TransactionId);
      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                                 CRYS_SST_TST_ATP_RSA_OAEP_ENCDEC,
                                 TST_MasterTestName);



       /* Setting test case specific parameters for key sizes */
        for (TST_index =0 ; TST_index < TST_NUM_OF_RSA_KEYS ; TST_index++) /*To run on all key types vectors*/
        {
            switch(TST_index)
            {
                    case 0:
                            TST_RSAKeySizeBits = TST_RSA_1024BIT_KEY;
                            TST_RSAKeySizeByts = TST_RSA_1024BIT_KEYSIZE_BYTES;
                            ATP_LOG_TST_PRINT((SST_TST_MSG,"\n*** RSA Key 1024 bit\n"));
                            break;
                    case 1:
                            TST_RSAKeySizeBits = TST_RSA_2048BIT_KEY;
                            TST_RSAKeySizeByts = TST_RSA_2048BIT_KEYSIZE_BYTES;
                            /*reinitializing for larger key*/
                            ATP_LOG_TST_PRINT((SST_TST_MSG,"\n*** RSA Key 2048 bit\n"));
                            break; 
                    default:
                            ATP_LOG_TST_PRINT((SST_TST_MSG,"\n***  wrong RSA Key \n"));
            };

            /* Generate RSA KeyPair inside the SST */
            /*-------------------------------------*/  
            TST_Status = CRYS_SST_RSA_KG_GenerateKeyPair(TST_TransactionId,
                                                        TST_SessionId,
                                                        TST_PasswordAuthHandle,
                                                        TST_RSA_KEYPAIR_TYPE,
                                                        &TST_RSA_KeyHandle,
                                                        TST_PubExponent,
                                                        sizeof(TST_PubExponent),
                                                        TST_RSAKeySizeBits,
                                                        &TST_KeyGenData1);


            TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                                               "CRYS_SST_RSA_KG_GenerateKeyPair",
                                               "CRYS_SST_TST_ATP_RSA_OAEP_ENCDEC",
                                                TST_MasterTestName);




            /*Encrypt the input buffer*/
            /*------------------------*/
            TST_Status =CRYS_SST_RSA_OAEP_Encrypt(TST_RSA_KeyHandle,
                                                TST_SessionId,
                                                &TST_keysAndPrimeDataCon,
                                                CRYS_RSA_HASH_SHA1_mode,
                                                DX_NULL,
                                                0,
                                                TST_MGF,
                                                TST_ASYMInputData,
                                                TST_InputDataSize,
                                                TST_EncOutput);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_RSA_OAEP_Encrypt",
                                                    "CRYS_SST_TST_ATP_RSA_OAEP_ENCDEC",
                                                    TST_MasterTestName);


            /*Decrypt the encrypted input buffer*/
            /*----------------------------------*/
            TST_Status =CRYS_SST_RSA_OAEP_Decrypt(TST_RSA_KeyHandle,
                                                 TST_SessionId,                        
                                                 &TST_keysAndPrimeDataCon,
                                                 CRYS_RSA_HASH_SHA1_mode,
                                                 DX_NULL,
                                                 0,
                                                 TST_MGF,
                                                 TST_EncOutput,
                                                 (DxUint16_t)TST_RSAKeySizeByts,
                                                 TST_DecOutput,
                                                 &TST_DecOutputSize);

          
            TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                     "CRYS_SST_RSA_OAEP_Decrypt",
                                       "CRYS_SST_TST_ATP_RSA_OAEP_ENCDEC",
                                        TST_MasterTestName);

            TST_DecOutputSize = TST_RSA_MAX_KEYSIZE_BYTES;

            /* Verify decrypted buffer equals the input buffer*/
            /*-------------------------------------------------*/
            if(!DX_VOS_MemCmp(TST_DecOutput,  TST_ASYMInputData, TST_RSA_OAEP_DATA_IN_SIZE))
                 TST_Status = TESTPASS; /*Data Buffers are the same*/
            else
                 TST_Status = TESTFAIL; /*Data Buffers are different*/

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                        "DX_VOS_MemCmp - Original data",
                        "CRYS_SST_TST_ATP_RSA_OAEP_ENCDEC",
                         TST_MasterTestName);
  
        

            /* Delete the keys */
            /*-----------------*/
            TST_Status = SST_DataDelete(TST_TransactionId,
                                          TST_SessionId,  
                                          TST_RSA_KeyHandle,
                                          TST_Workspace,
                                          TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                                      "SST_DataDelete - RSA key",
                                      "CRYS_SST_TST_ATP_RSA_OAEP_ENCDEC",
                                       TST_MasterTestName);



     }


     /*Delete the pass Authenticator*/
     TST_Status = SST_AuthenticatorDelete(TST_TransactionId,TST_PasswordAuthHandle);

     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorDelete", "CRYS_SST_TST_ATP_RSA_OAEP_ENCDEC", TST_MasterTestName);

   
    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                        DX_TRUE,/*reflash sensitive*/
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                "SST_TransactionEnd",
                              "CRYS_SST_TST_ATP_RSA_OAEP_ENCDEC",
                               TST_MasterTestName);




    /* Delete the session */
    /*--------------------*/
    TST_Status = SST_SessionDelete(TST_SessionId);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                "SST_SessionDelete",
                              "CRYS_SST_TST_ATP_RSA_OAEP_ENCDEC",
                               TST_MasterTestName);




    }/*End of TST_HandleType "for loop" */
    return TST_Status;

EXIT_ON_ERROR:  
    return DX_FAILURE;  
}/* End of SST_TST_ATP_PasswordAuthenticator */

/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_SST_TST_ATP_RSA
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 *    Test the connection between CRYS and the SSTfunctionality while using SST RSA generated keys
 *    in the CRYS_SST module
 *  
 * Algorithm:       
 *    1.    Create a new session by calling: SST_SessionCreate.
 *    2.    Open a transaction by calling: SST_TransactionStart.
 *    3.    Create a new  password authenticator.
 *    4.    Close the transaction.
 *    5.    Open the  password authentication.
 *    6.    Open a transaction for operations.
 *    7.    Generate RSA key Pair inside the SST by calling: CRYS_SST_RSA_KG_GenerateKeyPair.
 *    8.    Read the RSA Public Key from the SST by calling: SST_RSAPublicKeyRead. 
 *    9.    Build the RSA public key for CRYS usage by calling: CRYS_RSA_Build_PubKey 
 *    10.   Encrypt the data using the CRYS RSA key by calling: CRYS_RSA_PRIM_Encrypt.
 *    11.   Decrypt the data using the SST RSA key by calling: CRYS_SST_RSA_PRIM_Decrypt.
 *    12.   Compare the output wit the original input
 *    13.   Delete the RSA key by calling: SST_DataDelete.
 *    14.   Delete the pass Authenticator
 *    15.   Close the authenticator by calling: SST_AuthenticationClose.
 *    16.   Delete the authenticator by calling: SST_AuthenticatorDelete.
 *    17.   Close the transaction by calling: SST_TransactionClose.
 *    18.   Delete the session by calling: SST_SessionDelete.
 *                                
 *******************************************************************************/
DxError_t CRYS_SST_TST_ATP_RSA_Prim ( void )
{
    /********* TST Variables Definitions ************/
    int                         TST_HandleType;
    char                        TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_SST_TST_ATP_RSA_Prim";
    SSTSessionId_t              TST_SessionId; 
    SSTTxnId_t                  TST_TransactionId;
    SSTHandle_t                 TST_RSA_KeyHandle,TST_PasswordAuthHandle,TST_InitialCtrlAuth;
    DxUint8_t                   TST_PubExponent[TST_PUB_EXPONENT_SIZE] = {0x01,0x00,0x01};
    DxUint32_t                  TST_RSAKeySizeBits = 0,TST_index = 0, TST_RSAKeySizeByts = 0;
    DxUint8_t                   TST_E_RSAKey[TST_PUB_EXPONENT_SIZE];
    DxUint32_t                  TST_EsizeInBytes_RSAKey = sizeof(TST_E_RSAKey);
    CRYS_RSAUserPubKey_t        TST_RSA_KeyCTX;
    static                      CRYS_SST_RSA_keys_and_data_container_t TST_KeyGenData1;
    static                      CRYS_SST_RSA_keys_and_prime_data_container_t  TST_DataCont;
    static                      CRYS_RSAPrimeData_t  TST_PrimeData;
    DxUint16_t                  TST_InputDataSize = sizeof(TST_ASYMInputData);
    DxUint16_t                  TST_OutputDataSize = TST_RSA_MAX_KEYSIZE_BYTES;
    DxInt_t i;
    DxError_t                   TST_Status = TESTPASS;
    /********* TST Variables initialization *********/

    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ** CRYS_SST_TST_ATP_RSA Prim Tests ********************* \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n \n"));

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/

    for(i = 0; i< TST_RSA_MAX_KEYSIZE_BYTES; i++)
      TST_ASYMInputData[i] = (DxUint8_t)i;

    
  
    for (TST_HandleType = TST_INTERNAL_HANDLE ; TST_HandleType < TST_HANDLES_TYPES ; TST_HandleType++)
    {
            if (TST_HandleType == TST_INTERNAL_HANDLE)
            {   
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using internal handles          \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                TST_RSA_KeyHandle.objId = SST_HANDLE_RANDOM_GENERATE;                
                
            }
            else
            {
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using external handles          \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                TST_RSA_KeyHandle.objId = TST_TEST_DEFINED_HENDLE;                
                
            }


            /* Create a session for operations */
            /*---------------------------------*/
            TST_Status = SST_SessionCreate(&TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                    "SST_SessionCreate",
                    "CRYS_SST_TST_ATP_RSA",
                     TST_MasterTestName);


            /* Open a transaction for operations */
            /*-----------------------------------*/
            TST_Status = SST_TransactionStart(&TST_TransactionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                    "SST_TransactionStart",
                    "CRYS_SST_TST_ATP_RSA",
                     TST_MasterTestName);

      
          /* Create a new  password authenticator */
      /*--------------------------------------*/
      TST_InitialCtrlAuth.objDigest = 0;
      TST_InitialCtrlAuth.objId = SST_CLOSE_AUTH_HANDLE;
      TST_PasswordAuthHandle.objDigest = 0;
      TST_PasswordAuthHandle.objId = SST_HANDLE_RANDOM_GENERATE; 
      TST_Status = SST_AuthenticatorPasswordCreate(TST_TransactionId,
                                                   TST_SessionId, 
                                                   TST_ATP_PassAuthObjectTestData[0].TST_MasterPassword,
                                                   TST_ATP_PassAuthObjectTestData[0].TST_MasterPasswordSizeInBytes,
                                                   TST_ATP_PassAuthObjectTestData[0].TST_MasterMaxNumOfTrials,
                                                   TST_InitialCtrlAuth,
                                                   &TST_PasswordAuthHandle,
                                                   TST_Workspace,
                                                   TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorPasswordCreate ",
                                 CRYS_SST_TST_ATP_HMAC,
                                 TST_MasterTestName);


      /* Close the transaction */
      /*-----------------------*/
      TST_Status = SST_TransactionEnd(TST_TransactionId, DX_TRUE, TST_Workspace, TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                                 CRYS_SST_TST_ATP_HMAC,
                                 TST_MasterTestName);


      /* Open the  password authentication */
      /*-----------------------------------------*/
      TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                          TST_PasswordAuthHandle,
                                          TST_ATP_PassAuthObjectTestData[0].TST_MasterPassword,
                                          TST_ATP_PassAuthObjectTestData[0].TST_MasterPasswordSizeInBytes,
                                          TST_NO_CHALLENGE,
                                          TST_Workspace,
                                          TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen ",
                                 CRYS_SST_TST_ATP_HMAC,
                                  TST_MasterTestName);


      /* Open a transaction for operations */
      /*-----------------------------------*/
      TST_Status = SST_TransactionStart(&TST_TransactionId);
      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                                 CRYS_SST_TST_ATP_HMAC,
                                 TST_MasterTestName);




            /* Setting test case specific parameters for key sizes */
            for (TST_index =0 ; TST_index < TST_NUM_OF_RSA_KEYS ; TST_index++) /*To run on all key types vectors*/
            {
                switch(TST_index)
                {
                        case 0:
                                TST_RSAKeySizeBits = TST_RSA_1024BIT_KEY;  
                                TST_OutputDataSize = TST_RSA_1024BIT_KEY;
                                TST_RSAKeySizeByts = TST_RSA_1024BIT_KEYSIZE_BYTES;                              
                                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n*** RSA Key 1024 bit\n"));
                                break;
                        case 1:
                                TST_RSAKeySizeBits = TST_RSA_2048BIT_KEY;  
                                TST_OutputDataSize = TST_RSA_2048BIT_KEY;    
                                TST_RSAKeySizeByts = TST_RSA_2048BIT_KEYSIZE_BYTES;                          
                                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n*** RSA Key 2048 bit\n"));
                                break; 
                        default:
                                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n***  wrong RSA Key \n"));

                };

                /* Generate RSA KeyPair inside the SST */
                /*-------------------------------------*/  
                TST_Status = CRYS_SST_RSA_KG_GenerateKeyPair(TST_TransactionId,
                                                            TST_SessionId,
                                                            TST_PasswordAuthHandle,
                                                            TST_RSA_KEYPAIR_TYPE,
                                                            &TST_RSA_KeyHandle,
                                                            TST_PubExponent,
                                                            sizeof(TST_PubExponent),
                                                            TST_RSAKeySizeBits,
                                                            &TST_KeyGenData1);

          TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                      "CRYS_SST_RSA_KG_GenerateKeyPair",
                      "CRYS_SST_TST_ATP_RSA",
                       TST_MasterTestName);

          
          /* Read the RSA public Key from the SST */
                /*--------------------------------------*/
                TST_Status = SST_RSAPublicKeyRead(TST_SessionId,
                                                 TST_RSA_KeyHandle,
                                                 TST_N_RSAKey,
                                                 &TST_RSAKeySizeByts,
                                                 TST_E_RSAKey,
                                                 &TST_EsizeInBytes_RSAKey,
                                                 TST_Workspace,
                                                 TST_WorkspaceSizeInBytes);

          TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                      "SST_RSAPublicKeyRead",
                      "CRYS_SST_TST_ATP_RSA_Prim",
                       TST_MasterTestName);

        
        /* Build the RSA public keys for CRYS usage */
                /*------------------------------------------*/
                TST_Status = CRYS_RSA_Build_PubKey(&TST_RSA_KeyCTX,
                                                  TST_E_RSAKey,
                                                  (DxUint16_t)TST_EsizeInBytes_RSAKey,
                                                  TST_N_RSAKey,
                                                  (DxUint16_t)TST_RSAKeySizeByts);

          TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                      "CRYS_RSA_Build_PubKey - RSA Key",
                      "CRYS_SST_TST_ATP_RSA_Prim",
                       TST_MasterTestName);

          
                TST_InputDataSize = (DxUint16_t)TST_RSAKeySizeByts;
                /* Encrypt the data using the CRYS RSA key by calling: CRYS_RSA_PRIM_Encrypt */
                /*---------------------------------------------------------------------------*/
                TST_Status = CRYS_RSA_PRIM_Encrypt(&TST_RSA_KeyCTX,
                                                  &TST_PrimeData,
                                                  TST_ASYMInputData,
                                                  TST_InputDataSize,
                                                  TST_OutputData);                                          

          TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                      "CRYS_RSA_PRIM_Encrypt",
                      "CRYS_SST_TST_ATP_RSA_Prim",
                       TST_MasterTestName);


         
          TST_OutputDataSize = (DxUint16_t) TST_RSAKeySizeByts;              

         /* Decrypt the data using the SST RSA key by calling: CRYS_SST_RSA_PRIM_Decrypt*/
         /*-----------------------------------------------------------------------------*/
         TST_Status = CRYS_SST_RSA_PRIM_Decrypt(TST_RSA_KeyHandle,
                            TST_SessionId,
                           &TST_DataCont,
                          TST_OutputData,
                          TST_OutputDataSize,
                          TST_ReturnedOutputData);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                              "CRYS_SST_RSA_PRIM_Decrypt",
                  "CRYS_SST_TST_ATP_RSA",
                     TST_MasterTestName);

                
        /* Compare the output wit the original input */
        /*--------------------------------------------*/
        if(!DX_VOS_MemCmp(TST_ReturnedOutputData,
                    TST_ASYMInputData,
                    TST_InputDataSize))
                  TST_Status = TESTPASS; /*Data Buffers are the same*/
                else
                    TST_Status = TESTFAIL; /*Data Buffers are different*/

          TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                                "DX_VOS_MemCmp - Original data",
                      "CRYS_SST_TST_ATP_RSA_Prim",
                       TST_MasterTestName);

          
        
                /* Delete the key */
                /*----------------*/
                 TST_Status = SST_DataDelete(TST_TransactionId,
                                            TST_SessionId,  
                                            TST_RSA_KeyHandle,
                                            TST_Workspace,
                                            TST_WorkspaceSizeInBytes);

         TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                                 "SST_DataDelete - RSA key",
                     "CRYS_SST_TST_ATP_RSA",
                      TST_MasterTestName);

                 
            }

         /*Delete the pass Authenticator*/
         TST_Status = SST_AuthenticatorDelete(TST_TransactionId,TST_PasswordAuthHandle);

         TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorDelete", "CRYS_SST_TST_ATP_HMAC", TST_MasterTestName);


            /* Close the transaction */
            /*-----------------------*/
      TST_Status = SST_TransactionEnd(TST_TransactionId,
                       DX_TRUE,/*reflash sensitive*/
                       TST_Workspace,
                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                              "SST_TransactionEnd",
                    "CRYS_SST_TST_ATP_RSA",
                     TST_MasterTestName);


            /* Delete the session */
            /*--------------------*/
            TST_Status = SST_SessionDelete(TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                    "SST_SessionDelete",
                    "CRYS_SST_TST_ATP_RSA",
                     TST_MasterTestName);

    }/*End of TST_HandleType "for loop" */
    return TST_Status;

EXIT_ON_ERROR:
  {
  return DX_FAILURE;
  }
}/* End of CRYS_SST_TST_ATP_RSA_Prim */

/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/
#endif

